version 13 // indicates version
cls // clears backscroll display buffer
clear all // "start from scratch"
set more off // suppresses -more- prompts

/* load data */
cd "C:\Users\benja\Dropbox\BenjaminWork\ResearchProject\data\creation\data-sets and merge\vote behavior\recode"
use "vote behavior.dta" 

/* check for no duplicate entries */
bys nomem_encr: gen N = _N
assert N == 1
drop N // no duplicate entries
// individuals are nested in households, but this is ignored here 

/* rename variables (1) */
rename nomem_encr id

rename *cv08?(###)* .?(##)*
rename *cv09?(###)* .?(##)*
rename *cv10?(###)* .?(##)*
rename *cv11?(###)* .?(##)*
rename *cv12?(###)* .?(##)*
rename *cv13?(###)* .?(##)*
rename *cv14?(###)* .?(##)*

/* decode missings */
mvdecode _all, mv(3 99) 

/* creation of scores */

/* 
remark:
- whether or not the respondent voted in 2006 is obtained 5 times; 
  whether or not the respondent voted in 2012 is obtained 2 times;
  we aggregate these variables to one dummy variable by creating the 
  mean and rounding to either 0 or 1 with the cutoffpoint being 0.5
- ! there was an election in 2010; it could be that the information in wave
  2011 and 12 actually refer to this election and the staff made an recoding error?!
  
  corr cv08a053 cv09b053 cv10c053 cv11d053 cv12e053 cv13f053 cv14g053
  is inconclusive
  
*/

/* aggregation of information */
egen el2006 = rowmean(a53 b53 c53 d53 e53)
replace el2006 = round(2 - el2006, 1) 
// variable is recoded 1=yes, 2=0; by calculating 2-original value we create a proper
// dummy: 1=yes, 0=no; as these values are averages, we round to either 0 or 1
label var el2006 "Respondent voted in 2006 (1=yes)"

egen el2012 = rowmean(f53 g53)
replace el2012 = round(2 - el2012, 1)
label var el2012 "Respondent voted in 2012 (1=yes)"

egen vote = rowtotal(el2006 el2012), missing  // ordinal operationalization (sum of voting in 06 and 12 given at least some information)
label var vote "Respondent voted x out of 2 times"

gen voted = vote > 0 if !missing(vote) // dichotomous operationalization (voted either in 06 or in 12; create missing if both missing, otherwise 0)
replace voted = vote if vote == 0
label var voted "Respondent voted at least once"

/* creation of data sets */
keep(id voted)

/* duplicate the information 6 times (2008-2013) */
expand 6
bys id: gen wave = 7 + _n // create artifical waves

////////////////////// WIDE /////////////////////////////////
stata2mplus using votebehavior, replace
/////////////////////////////////////////////////////////////

////////////////////// LONG /////////////////////////////////
//     makes no sense here as it is already long           //
/////////////////////////////////////////////////////////////

////////////// STATA FILE FOR MERGING ///////////////////////
saveold d10_vote, replace
/////////////////////////////////////////////////////////////




